#!/usr/bin/env bash
HERE="$(cd "$(dirname "$0")" && pwd)"
BIN="$HERE/bin"
export CAPTURE_ROOT="$HERE"
export XDG_DATA_DIRS="$HERE/share:${XDG_DATA_DIRS:-/usr/local/share:/usr/share}"
export QT_DESKTOP_FILE_NAME="io.calibio.capture.desktop"
export LD_LIBRARY_PATH="${BIN}/lib:${LD_LIBRARY_PATH}"
export QT_PLUGIN_PATH="${BIN}/lib/qtplugins"
export QT_QPA_PLATFORM="${QT_QPA_PLATFORM:-xcb}"

install_user_desktop_entry() {
    local src="$HERE/share/applications/io.calibio.capture.desktop"
    local target="$HOME/.local/share/applications/io.calibio.capture.desktop"
    if [ ! -f "$src" ]; then
        return
    fi
    mkdir -p "$(dirname "$target")"
    local tmp="${target}.tmp"
    sed "s|@CAPTURE_ROOT@|$HERE|g" "$src" > "$tmp"
    if ! cmp -s "$tmp" "$target" 2>/dev/null; then
        mv "$tmp" "$target"
    else
        rm -f "$tmp"
    fi
}

install_user_desktop_entry
exec "${BIN}/capture" "$@"
